%    This library is free software; you can redistribute it and/or
%    modify it under the terms of the GNU Lesser General Public
%    License as published by the Free Software Foundation; either
%    version 2.1 of the License, or (at your option) any later version.

%    This library is distributed in the hope that it will be useful,
%    but WITHOUT ANY WARRANTY; without even the implied warranty of
%    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
%    Lesser General Public License for more details.

%    You should have received a copy of the GNU Lesser General Public License 
%    (lgpl_license.txt) along with this library; if not, write to the Free Software
%    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

function choose_boundary_point(iteration)

filename = ['init_to_inter_lsm_', num2str(iteration), '_unique'];
fid = fopen(filename, 'r');

A = fscanf(fid, '%f %f', [2 inf]); 
A = A';
fclose(fid); 

h = figure; 
plot(A(:,1), A(:,2), 'Color', 'r');
hold on; 
plot(A(3,1), A(3,2), 'x', 'LineWidth', 2, 'MarkerSize', 10, 'MarkerEdgeColor', rgb('Red')); 

% for i=100:100:1300
%     hold on; 
%     plot(A(i,1), A(i,2), 'x', 'LineWidth', 5, 'MarkerSize', 10, 'MarkerEdgeColor', rgb('Black'));
% end
% hold on;

C = A(1:6:end,:);
C(1,1) = A(3,1); 
C(1,2) = A(3,2);
hold on;
plot(C(:,1), C(:,2), 'x');


fid = fopen('outer_init_xy_lsm', 'r'); 

B = fscanf(fid, '%d %d', [2 inf]); 
B = B';
fclose(fid); 

hold on;
plot(B(:,1), B(:,2), 'x'); 



filename = ['init_to_inter_lsm_', num2str(iteration), '_boundary.poly'];
fid = fopen(filename, 'w');
index = 1;
while index <= size(C,1)
    fprintf(fid, '%d\t%f\t%f\t%d\n', index, C(index,1), C(index,2), 1);
    index = index + 1;
end

index = 1;
while index <= size(B,1)
    fprintf(fid, '%d\t%f\t%f\t%d\n', index+size(C,1), B(index,1), B(index,2), 2);
    index = index + 1;
end
fclose(fid);





